(defun count-shares (form)
  (cond ((vec-p form)
	 (dotimes (i (vec-num-bits form))
	   (count-shares (vec-get-bit form i))))
	((formula-p form)
;;	 (when (eq (formula-fn form) 'const) (break "const"))
	 (unless (natp (formula-slot1 form)) (setf (formula-slot1 form) 0))
	 (when (= (formula-slot1 form) 0)
	   (mapcar #'count-shares (formula-args form)))
	 (incf (formula-slot1 form))))
  nil)

;; (defun creturn (form nform cp)
;;   (setf (formula-slot2 form) (cons nform cp))
;;   (unless (or (eq form nform)
;; 	      (natp (formula-slot1 nform)))
;;     (setf (formula-slot1 nform) 1))
;;   (values nform cp))
	
;; (defun flatten-aux-list (lst)
;;   (let ((cp nil))
;;     (loop for form in lst
;; 	  collect (multiple-value-bind
;; 		      (nform ncp)
;; 		      (flatten-aux form)
;; 		    (unless (or cp (not ncp)) (setf cp ncp))
;; 		    nform) into nforms
;; 	  finally (return (values nforms cp)))))

;; (defun flatten-aux (form)
;;   (cond ((vec-p form)
;; 	 (let* ((cp nil)
;; 		(n (vec-num-bits form))
;; 		(vec (new-vec n)))
;; 	   (dotimes (i n (values (make-unique-vec vec) cp))
;; 	     (multiple-value-bind
;; 		 (veci ncp)
;; 		 (flatten-aux (vec-get-bit form i))
;; 	       (unless (or cp (not ncp)) (setf cp ncp))
;; 	       (vec-set-bit vec i veci)))))
;; 	((not (formula-p form)) (values form nil))
;; 	((formula-slot2 form)
;; 	 (values (car (formula-slot2 form))
;; 		 (cdr (formula-slot2 form))))
;; 	((eq (formula-fn form) 'const) (values form nil))
;; 	((member (formula-fn form) '(var _zero_mem const)) (creturn form form nil))
;; 	((eq (formula-fn form) 'and)
;; 	 (multiple-value-bind
;; 	     (args cp)
;; 	     (flatten-aux-list (formula-args form))
;; 	   (let ((fp nil))
;; 	     (loop for arg in args
;; 		   if (and (eq (formula-fn arg) 'and)
;; 			   (= (formula-slot1 arg) 1))
;; 		     do (unless fp (setf fp t))
;; 		     and append (formula-args arg) into nargs
;; 		   else
;; 		     collect arg into nargs
;; 		   finally (return (if (or fp cp)
;; 				       (creturn form (sb-and-form nargs) t)
;; 				     (creturn form form nil)))))))
;; 	(t
;; 	 (multiple-value-bind
;; 	     (args cp)
;; 	     (flatten-aux-list (formula-args form))
;; 	   (cond (cp (creturn form
;; 			      (case (formula-fn form)
;; 				(<-> (equiv-form args))
;; 				(not (sb-not-form (car args)))
;; 				(bit (apply #'get-bit args))
;; 				(=   (equals-form args))
;; 				(if  (if-form args))
;; 				(get (apply   #'get-form args))
;; 				(set (apply   #'set-form args))
;; 				(mv  (mv-form (formula-type form) args))
;; 				(otherwise (break (format nil "~&flatten: unknown function ~A.~%" (formula-fn form)))))
;; 			      t))
;; 		 (t (creturn form form nil)))))))
					    
;; (defun flatten (form)
;;   (count-shares form)
;;   (multiple-value-bind
;;       (nform cp)
;;       (flatten-aux form)
;;     (declare (ignore cp))
;;     (clear-slot1 nform)
;;     (scrub-slots form)
;;     nform))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	
(defun flatten-and-args (args nargs)
  (cond ((endp args)
	 nargs)
	((and (eq (formula-fn (car args)) 'and)
	      (= (formula-slot1 (car args)) 1))
	 (setf (formula-slot2 (car args)) t) ;; set slot2 of the arg so clear-slot2 works properly.
	 (flatten-and-args (cdr args)
			   (flatten-and-args (formula-args (car args))
					     nargs)))
	(t
	 (flatten-and-args (cdr args)
			   (cons (flatten-aux (car args)) nargs)))))


(defun flatten-aux (fv)
  (cond ((vec-p fv)
	 (let* ((n (vec-num-bits fv))
		(vec (new-vec n)))
	   (dotimes (i n (make-unique-vec vec))
	     (vec-set-bit vec i (flatten-aux (vec-get-bit fv i))))))
	((not (formula-p fv)) fv)
	((formula-slot2 fv) (formula-slot2 fv))
	((eq (formula-fn fv) 'and)
	 (setf (formula-slot2 fv)
	       (sb-and-form (flatten-and-args (formula-args fv) nil))))
	(t
	 (let ((args (mapcar #'flatten-aux (formula-args fv))))
	   (setf (formula-slot2 fv)
		 (case (formula-fn fv)
		   (var fv)
		   (const fv)
		   (<-> (equiv-form args))
		   (not (sb-not-form (first args)))
		   (bit (apply #'get-bit args))
		   (=   (equals-form args))
		   (if (if-form args))
		   (get (apply #'get-form args))
		   (set (apply #'set-form args))
		   (otherwise
		    (break (format nil "flatten: unknown function: ~A"
				   (formula-fn fv))))))))))

(defun flatten (form)
  (count-shares form)
  (let ((ans (flatten-aux form)))
    (clear-both-slots form)
    ans))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;






(defun deflatten-aux (form)
  (cond ((vec-p form)
	 (let* ((nb (vec-num-bits form))
		(vec (new-vec nb)))
	   (dotimes (i nb (make-unique-vec vec))
	     (vec-set-bit vec i (deflatten-aux (vec-get-bit form i))))))
	((not (formula-p form)) form)
	((formula-slot1 form) (formula-slot1 form))
	(t
	 (setf (formula-slot1 form)
	       (let ((args (mapcar #'deflatten-aux (formula-args form))))
		 (case (formula-fn form)
		   (and (if (endp (rest (rest args)))
			    form
			  (let ((nform (first args)))
			    (loop for arg in (rest args)
				  do (setf nform (sb-and-form (list nform arg)))
				  finally (return nform)))))
		   (var form)
		   (const form)
		   (<-> (equiv-form args))
		   (not (sb-not-form (first args)))
		   (bit (apply #'get-bit args))
		   (=   (equals-form args))
		   (if (if-form args))
		   (get (apply #'get-form args))
		   (set (apply #'set-form args))
		   (mv (mv-form (formula-type form) args))
		   (otherwise
		    (break (format nil "unflatten: unknown function: ~A"
				   (formula-fn form))))))))))

(defun deflatten (form)
  (let ((nform (deflatten-aux form)))
    (clear-slot1 form)
    nform))

;;;;;;;;;;;;;;;;;;;;;;;
;;; and propagation ;;;
;;;;;;;;;;;;;;;;;;;;;;;

;; (defstruct ap-struct
;;   (global-count 0 :type fixnum)
;;   (local-count  0 :type fixnum)
;;   (changed nil :type boolean)
;;   (answer nil :type (or nil formula)))

;; (defun ap-setup (form)
;;   (cond ((vec-p form)
;; 	 (dotimes (i (vec-num-bits form))
;; 	   (ap-setup (vec-get-bit form i))))
;; 	((not (formula-p form)) nil)
;; 	((formula-slot2 form)
;; 	 (incf (ap-struct-global-count (formula-slot2 form))))
;; 	(t
;; 	 (setf (formula-slot2 form)
;; 	       (make-ap-struct :global-count 1))
;; 	 (loop for arg in (formula-args form) do (ap-setup arg))))
;;   nil)

;; (defun ap-reset (form)
;;   (cond ((vec-p form)
;; 	 (dotimes (i (vec-num-bits form))
;; 	   (ap-reset (vec-get-bit form i))))
;; 	((not (formula-p form)) nil)
;; 	((not (= (ap-struct-local-count (formula-slot2 form)) 0))
;; 	 (setf (ap-struct-local-count (formula-slot2 form)) 0)
;; 	 (setf (ap-struct-answer (formula-slot2 form)) nil)
;; 	 (loop for arg in (formula-args form) do (ap-reset arg))))
;;   nil)

;; (defun ap-local-count (form)
;;   (cond ((vec-p form)
;; 	 (dotimes (i (vec-num-bits form))
;; 	   (ap-local-count (vec-get-bit form i))))
;; 	((not (formula-p form)) nil)
;; 	(t
;; 	 (when (= (ap-struct-local-count (formula-slot2 form)) 0)
;; 	   (loop for arg in (formula-args form) do (ap-local-count arg)))
;; 	 (incf (ap-struct-local-count (formula-slot2 form)))))
;;   nil)

;; (defun make-ap-ready-form (&key (fn 'none) (type '(bv 1)) (args nil))
;;   (let* ((form (make-unique-formula :fn fn :type type :args args))
;; 	 (slot2 (formula-slot2 form)))
;;     (cond (slot2 (incf (ap-struct-global-count slot2))
;; 		 (incf (ap-struct-local-count slot2)))
;; 	  (t (setf (formula-slot2 form)
;; 		   (make-ap-struct :global-count 1
;; 				   :local-count 1))))))

;; (declaim (ftype (function (list) boolean) or-list))
;; (defun or-list (lst)
;;   (dolist (x lst nil)
;;     (when x (return t))))

;; (declaim (ftype (function (list list hash-table) boolean) var-byt-in-form-list-p))
;; (defun var-bit-in-form-list-p (lst vbhset fhset)
;;   (or-list (mapcar #'(lambda (x) (var-bit-in-form-p x vbhset fhset))
;; 		   lst)))

;; (defmacro memberp (x lst)
;;   `(not (null (member ,x ,lst))))

;; (declaim (ftype (function (formula list hash-table) boolean) var-bit-in-form-p))
;; (defun var-bit-in-form-p (form vbhset fhset)
;;   (multiple-value-bind
;;     (val visited)
;;     (gethash (formula-value form) fhset)
;;     (cond (visited val)
;; 	  ((eq (car (formula-type form)) 'mem)
;; 	   (setf (gethash (formula-value form) fhset) nil))
;; 	  (t 
;; 	   (case (formula-fn form)
;; 	     (var (setf (gethash (formula-value form) fhset) 
;; 			(memberp form vbhset)))
;; 	     (get (setf (gethash (formula-value form) fhset) nil))
;; 	     (bit (setf (gethash (formula-value form) fhset)
;; 			(var-bit-in-form-p (first (formula-args form)) vbhset fhset)))
;; 	     (otherwise (setf (gethash (formula-value form) fhset)
;; 			      (var-bit-in-form-list-p (formula-args form)
;; 						      vbhset fhset))))))))

;; (declaim (ftype (function (list boolean) list) ps-and-simplify-list1))
;; (defun ps-and-simplify-list1 (lst changed)
;;   (if (endp lst)
;;       (values nil changed)
;;     (multiple-value-bind
;; 	(ncar chng-car)
;; 	(ps-and-simplify (car lst))
;;       (multiple-value-bind
;; 	  (ncdr chng-cdr)
;; 	  (ps-and-simplify-list1 (cdr lst) (or changed chng-car))
;; 	(values (cons ncar ncdr) chng-cdr)))))

;; (declaim (ftype (function (list) list) ps-and-simplify-list))
;; (defun ps-and-simplify-list (lst)
;;   (ps-and-simplify-list1 lst nil))

;; (declaim (ftype (function (formula formula boolean) (values formula boolean)) psaf-return))
;; (defun psaf-return (form nform cp)
;;   (let ((s2 (formula-slot2 form)))
;;     (setf (ap-struct-answer s2) nform)
;;     (setf (ap-struct-changed s2) cp)
;;     (values nform cp)))

;; (declaim (ftype (function (function formula) (values formula boolean)) ps-and-simplify1))
;; (defun ps-and-simplify1 (construct form)
;;   (multiple-value-bind
;;       (nargs changed)
;;       (ps-and-simplify-list (formula-args form))
;;     (cond (changed (psaf-return form (funcall construct nargs) t))
;; 	  (t (psaf-return form form nil)))))

;; (declaim (ftype (function (form-vec) (values form-vec boolean)) ps-and-simplify))
;; (defun ps-and-simplify (form)
;;   (cond ((vec-p form)
;; 	 (let* ((nb (vec-num-bits form))
;; 		(vec (new-vec (vec-num-bits form))))
;; 	   (dotimes (i nb (let ((vec (make-unique-vec vec)))
;; 			    (values vec (not (eq vec form)))))
;; 	     (multiple-value-bind
;; 		 (nform cp)
;; 		 (ps-and-simplify (vec-get-bit form i))
;; 	       (declare (ignore cp))
;; 	       (vec-set-bit vec i nform)))))
;; 	((ap-struct-answer (formula-slot2 form))
;; 	 (values (ap-struct-answer (formula-slot2 form))
;; 		 (ap-struct-changed (formula-slot2 form))))
;; 	((not (= (ap-struct-global-count (formal-slot2 form))
;; 		 (ap-struct-local-count (formal-slot2 form))))
;; 	 (psaf-return form form nil))
;; 	(t
;; 	 (case (formula-fn form)
;; 	   (var (psaf-return form form nil))
;; 	   (and (ps-and-simplify1 #'sb-and-form form))
;; 	   (<-> (ps-and-simplify1 #'sb-equiv-form form))
	   
;; 	   (not (multiple-value-bind
;; 		    (narg chng)
;; 		    (ps-and-simplify (car (formula-args form)))
;; 		  (cond (chng (psaf-return form (sb-not-form narg) t))
;; 			(t (psaf-return form form nil)))))
;; 	   (bit (let* ((arg (first (formula-args form)))
;; 		       (args (formula-args arg)))
;; 		  (cond ((not (eq (formula-fn arg) 'get))
;; 			 (break "At this point, bit should be applied only to a get form.")
;; 			 (psaf-return form form nil))
;; 			((not (formula-slot2 arg))
;; 			 (multiple-value-bind
;; 			     (nmem c)
;; 			     (ps-and-simplify (first args))
;; 			     (if c
;; 				 (let ((ngf (get-form nmem
;; 						      (second args)
;; 						      (third args))))
;; 				   (setf (formula-slot2 arg)
;; 					 (cons ngf t))
;; 				   (psaf-return form
;; 						 (get-bit ngf (second (formula-args form)))
;; 						 t))
;; 			       (progn (setf (formula-slot2 arg) (cons arg nil))
;; 				      (psaf-return form
;; 						   form
;; 						   nil)))))
;; 			((eq (cdr (formula-slot2 arg)) t)
;; 			 (psaf-return form
;; 				      (get-bit (car (formula-slot2 arg))
;; 					       (second (formula-args form)))
;; 				      t))
;; 			(t
;; 			 (psaf-return form form nil)))))
;; 	   (set (multiple-value-bind
;; 		    (narg chng)
;; 		    (ps-and-simplify (first (formula-args form)))
;; 		  (cond (chng (psaf-return form
;; 					   (set-form narg
;; 						     (second (formula-args form))
;; 						     (third (formula-args form)))
;; 					   t))
;; 			(t (psaf-return form form nil)))))
;; 	   (= (ps-and-simplify1 #'equals-form form))
;; 	   (if (ps-and-simplify1 #'if-form form))
;; 	   (otherwise
;; 	    (break (format nil"~&ps-and-simplify: unknown fn: ~A~%"
;; 			   (formula-fn form)))
;; 	    (values form nil))))))

;; (declaim (ftype (function (formula) formula) ps-and-simplify-clear-slot2))
;; (defun ps-and-simplify-clear-slot2 (form)
;;   (let ((x (ps-and-simplify form)))
;;     (clear-slot2 form)
;;     x))

;; (declaim (ftype (function (list) boolean) sorted?))
;; (defun sorted? (lst)
;;   (let ((cur (car lst)))
;;     (dolist (form lst t)
;;       (when (> (formula-value form) (formula-value cur))
;; 	(return nil))
;;       (setf cur form))))

;; ;;; new and propagation algorithm:

;; (declaim (ftype (function (formula) null) ap-set-form-to-true))
;; (defun ap-set-form-to-true (form)
;;   (unless (formula-slot2 form)
;;     (setf (formula-slot2 form) (cons *one* t))
;;     (case (formula-fn form)
;;       (not (setf (formula-slot2 (first (formula-args form)))
;; 		 (cons *zero* t)))
;;       (and (mapcar #'ap-set-form-to-true (formula-args form)))
;;       (<-> (let* ((eargs (formula-args form))
;; 		  (arg1 (first eargs))
;; 		  (arg2 (second eargs)))
;; 	     (if (< (formula-depth arg2) (formula-depth arg1))
;; 		 (setf (formula-slot2 arg1) (cons arg2 t))
;; 	       (setf (formula-slot2 arg2) (cons arg1 t))))))
;;     nil))

;; (declaim (ftype (function (list) (or formula list)) and-propagation2))
;; (defun and-propagation2 (args)
;;   (let ((args args))
;;     (cond ((atom args) args)
;; 	  ((endp (cdr args)) (car args))
;; 	  (t
;; 	   (let ((nargs nil)
;; 		 (changed t)
;; 		 (i 0))
;; 	     (loop while (and changed (< i 10)) do
;; 		   (let ((arg (car args)))
;; 		     (incf i)
;; 		     (setf changed nil)
;; 		     (setf nargs (list arg))
;; 		     (ap-set-form-to-true arg)
;; 		     (dolist (arg (cdr args))
;; 		       (multiple-value-bind
;; 			   (narg chng)
;; 			   (ps-and-simplify arg)
;; 			 (or changed (setf changed chng))
;; 			 (clear-slot2 arg)
;; 			 (cond ((eq narg *zero*)
;; 				(mapcar #'clear-slot2 nargs)
;; 				(return-from and-propagation2 *zero*))
;; 			       ((not (eq narg *one*))
;; 				(setf nargs (cons narg nargs))
;; 				(ap-set-form-to-true narg)))))
;; 		     (mapcar #'clear-slot2 nargs)
;; 		     (setf args (and-args nargs))
;; 		     (when (atom args) (return-from and-propagation2 args))
;; 		     (setf nargs nil)))
;; 	     args)))))

;; (declaim (ftype (function (list list) list) and-propagation1-list))
;; (defun and-propagation1-list (forms visited)
;;   (let ((visited visited))
;;     (values (mapcar (lambda (x)
;; 		      (if (typep x 'form-vec)
;; 			  (multiple-value-bind
;; 			      (nx nv)
;; 			      (and-propagation1 x visited)
;; 			    (setf visited nv)
;; 			    nx)
;; 			x))
;; 		    forms)
;; 	    visited)))

;; (declaim (ftype (function (formula t) boolean) subform1))
;; (defun subform1 (form1 form2)
;;   (cond ((vec-p form2)
;; 	 (dotimes (i (vec-num-bits form2) nil)
;; 	   (when (subform1 form1 (vec-get-bit form2 i))
;; 	     (return t))))
;; 	((mem-p form2)
;; 	 (block loops
;; 	   (dotimes (i (mem-num-words form2) nil)
;; 	     (dotimes (j (mem-wordsize form2))
;; 	       (when (subform1 form1 (mem-get-bit form2 i j))
;; 		 (return-from loops t))))))
;; 	((not (formula-p form2)) nil)
;; 	((formula-slot2 form2) nil)
;; 	((eq form1 form2) t)
;; 	(t (setf (formula-slot2 form2) t)
;; 	   (cond ((< (formula-value form1)
;; 		     (formula-value form2))
;; 		  ;; formula-values get smaller, so form2's value must
;; 		  ;; be < form1's to contain it.
;; 		  nil)
;; 		 ((<= (formula-depth form2)
;; 		      (formula-depth form1))
;; 		  nil)
;; 		 (t (dolist (arg (formula-args form2) nil)
;; 		      (when (subform1 form1 arg) (return t))))))))

;; (declaim (ftype (function (formula formula) boolean) subform))
;; (defun subform (form1 form2)
;;   (let ((ans (subform1 form1 form2)))
;;     (clear-slot2 form2)
;;     ans))

;; (declaim (ftype (or (function (formula list) (values form-vec list))
;; 		    (function (vec list) (values vec list)))
;; 		and-propagation1))
;; (defun and-propagation1 (form visited)
;;   (cond ((vec-p form)
;; 	 (let* ((vb (vec-num-bits form))
;; 		(vec (new-vec vb))
;; 		(v visited))
;; 	   (dotimes (i vb (values (make-unique-vec vec) v))
;; 	     (multiple-value-bind
;; 		 (nf nv)
;; 		 (and-propagation1 (vec-get-bit form i) v)
;; 	       (progn (setf v nv)
;; 		      (vec-set-bit vec i nf))))))
;; ;; 	((not (formula-p form))
;; ;; 	 (values form visited))
;; 	((formula-slot1 form)
;; 	 (values (the form-vec (formula-slot1 form)) visited))
;; 	(t
;; 	 (multiple-value-bind
;; 	     (nform nv)
;; 	     (case (formula-fn form)
;; 	       (const (values form visited))
;; 	       (var (values form visited))
;; 	       (and (let ((nargs (and-propagation2 (formula-args form))))
;; 		      (if (atom nargs)
;; 			  (multiple-value-bind
;; 			      (nform nv)
;; 			      (and-propagation1 nargs visited)
;; 			    (values nform nv))
;; 			(multiple-value-bind
;; 			    (nnargs nv)
;; 			    (and-propagation1-list (and-args nargs) visited)
;; 			  (values (sb-and-form nnargs) nv)))))
;; 	       (if (let* ((args (formula-args form))
;; 			  (test (first args))
;; 			  (then (second args))
;; 			  (else (third args)))
;; 		     (multiple-value-bind
;; 			 (ntest nv)
;; 			 (and-propagation1 test visited)
;; 		       (let* ((nthen (progn (ap-set-form-to-true ntest)
;; 					    (ps-and-simplify-clear-slot2 then)))
;; 			      (negtest (sb-not-form ntest))
;; 			      (nelse (progn (clear-slot2 ntest)
;; 					    (ap-set-form-to-true negtest)
;; 					    (ps-and-simplify-clear-slot2 else))))
;; 			 (clear-slot2 negtest)
;; 			 (multiple-value-bind
;; 			     (nargs nv)
;; 			     (and-propagation1-list (list nthen nelse) nv)
;; 			   (values (if (and (eq test ntest)
;; 					    (equal nargs (list then else)))
;; 				       form
;; 				     (if-form (cons ntest nargs)))
;; 				   nv))))))
;; 	       (<-> (multiple-value-bind
;; 			(nargs nv)
;; 			(and-propagation1-list (formula-args form) visited)
;; 		      (let* ((nnargs (sortforms nargs))
;; 			     (arg1 (first nnargs))
;; 			     (arg2 (second nnargs)))
;; 			(if (subform arg1 arg2)
;; 			    (let* ((then (progn (ap-set-form-to-true arg1)
;; 						(ps-and-simplify-clear-slot2 arg2)))
;; 				   (negarg1 (sb-not-form arg1))
;; 				   (else (progn (clear-slot2 arg1)
;; 						(ap-set-form-to-true negarg1)
;; 						(ps-and-simplify-clear-slot2 (sb-not-form arg2)))))
;; 			      (clear-slot2 negarg1)
;; 			      (values (if-form (list arg1 then else)) nv))
;; 			  (values (equiv-form nnargs) nv)))))			
;; 	       (otherwise 
;; 		(multiple-value-bind
;; 		    (nargs nv)
;; 		    (and-propagation1-list (formula-args form) visited)
;; 		  (values (simplify1-step (formula-fn form)
;; 					  (formula-type form)
;; 					  nargs
;; 					  nil nil nil)
;; 			  nv))))
;; 	   (values (setf (formula-slot1 form) (the form-vec nform)) (cons form nv))))))

;; ;; (defun has-const1 (form)
;; ;;   (cond ((not (formula-p form)) nil)
;; ;; 	((formula-slot2 form) nil)
;; ;; 	((eq (formula-fn form) 'const) (break))
;; ;; 	(t (setf (formula-slot2 form) t)
;; ;; 	   (mapcar #'has-const1 (formula-args form)))))

;; ;; (defun has-const? (form)
;; ;;   (has-const1 form)
;; ;;   (clear-slot2 form))

;; (declaim (ftype (function (formula) formula) and-propagation))
;; (defun and-propagation (form)
;;   (let ((form form));;(flatten form)))
;;     (if *ap*
;; 	(let ((v nil)) ;;(pre-ap form)))
;; 	  (multiple-value-bind
;; 	      (nform visited)
;; 	      (and-propagation1 form v)
;; 	    (mapcar (lambda (form) (setf (formula-slot1 form) nil)) visited)
;; 	    nform))
;;       form)))

(defvar *domnode-count* 0)

(defstruct (domnode (:print-function print-domnode))
  (value 0 :type fixnum)
  (parent nil :type (or domnode null))
  (children nil :type list)
  (height 0 :type fixnum)
  (form *junk* :type formula))

(defun print-domnode (s stream depth)
  (declare (ignore depth))
  (let ((lst `(domnode ,(domnode-value s) 
		       :parent ,(if (domnode-parent s) (domnode-value (domnode-parent s)) nil)
		       :children ,(domnode-children s)
		       :height ,(domnode-height s)
		       :form ,(formula-value (domnode-form s)))))
    (format stream "~A" lst)))

(defun compute-form-parents-aux (form)
  (cond ((vec-p form)
	 (dotimes (i (vec-num-bits form))
	   (compute-form-parents-aux (vec-get-bit form i))))
	((and (formula-p form)
	      (not (formula-slot1 form)))
	 (dolist (arg (formula-args form))
	   (cond ((vec-p arg)
		  (dotimes (i (vec-num-bits arg))
		    (let ((veci (vec-get-bit arg i)))
		      (setf (formula-slot2 veci)
			    (cons form (formula-slot2 veci))))))
		 ((formula-p arg)
;;		  (format t "adding ~A to parents of ~A~%" form arg)
		  (setf (formula-slot2 arg)
			(cons form (formula-slot2 arg)))))
	   (compute-form-parents-aux arg))
	 (setf (formula-slot1 form) t)))
  nil)

(defun compute-form-parents (form)
  (compute-form-parents-aux form)
  (clear-slot1 form)
  nil)

(defun bnca (n1 n2)
  (if (eq n1 n2)
      n1
    (let ((h1 (domnode-height n1))
	  (h2 (domnode-height n2)))
      (cond ((< h1 h2) (bnca n1 (domnode-parent n2)))
	    ((< h2 h1) (bnca (domnode-parent n1) n2))
	    (t (bnca (domnode-parent n1)
		     (domnode-parent n2)))))))

(defun nca (nodes)
  (if (endp nodes)
      nil
    (let ((nca (car nodes)))
      (dolist (node (cdr nodes) nca)
	(setf nca (bnca nca node))))))

(defun build-dom-node (form)
  (let* ((parent (nca (mapcar #'formula-slot1 (formula-slot2 form))))
	 (node (make-domnode :value (incf *domnode-count*)
			     :parent parent
			     :height (if parent (1+ (domnode-height parent)) 0)
			     :form form)))
    (setf (formula-slot1 form) node)
    (when parent
      (setf (domnode-children parent) (cons node (domnode-children parent))))))

;; (defun build-dom-tree-aux-list (list)
;;   (dolist (fv list)
;;     (cond ((vec-p fv)
;; 	   (dotimes (i (vec-num-bits fv))
;; 	     (build-dom-tree-aux (vec-get-bit fv i))))
;; 	  ((formula-p fv)
;; 	   (build-dom-tree-aux fv)))))

;; (defun build-dom-tree-aux (form)
;;   (unless (formula-slot1 form)
;;     (build-dom-node form)
;;     (build-dom-tree-aux-list (formula-args form)))
;;   (formula-slot1 form))

(defun sort-domnodes (list)
  (sort list
	#'>
	:key (lambda (x) (formula-value (domnode-form x)))))

(defun sort-children (tree)
  (dolist (child (domnode-children tree)) (sort-children child))
  (setf (domnode-children tree)
	(sort-domnodes (domnode-children tree)))
  tree)

(defun heap-add-arg (heap arg)
  (cond ((vec-p arg)
	 (dotimes (i (vec-num-bits arg))
	   (heap-add-arg heap (vec-get-bit arg i))))
	((and (formula-p arg)
	      (not (formula-slot1 arg)))
	 (heap-insert heap arg)
	 (setf (formula-slot1 arg) t))))







;; (defun flatten-and-args-aux (args dchildren changed nargs nchildren rchildren)
;;   (cond ((endp args) (values (and-args nargs)
;; 			     (sort-domnodes (append dchildren nchildren))
;; 			     rchildren
;; 			     changed))
;; 	((endp dchildren) (values (and-args (append args nargs))
;; 				  (sort-domnodes nchildren)
;; 				  rchildren
;; 				  changed))
;; 	(t (let* ((arg (car args))
;; 		  (child (car dchildren))
;; 		  (cform (domnode-form child)))
;; 	     (cond ((< (formula-value arg)
;; 		       (formula-value cform))
;; 		    (flatten-and-args-aux args
;; 				      (cdr dchildren)
;; 				      changed
;; 				      nargs
;; 				      (cons child nchildren)
;; 				      rchildren))
;; 		   ((> (formula-value arg)
;; 		       (formula-value cform))
;; 		    (flatten-and-args-aux (cdr args)
;; 				      dchildren
;; 				      changed
;; 				      (cons arg nargs)
;; 				      nchildren
;; 				      rchildren))
;; 		   ((eq (formula-fn arg) 'and)
;; 		    (flatten-and-args-aux (cdr args)
;; 				      (cdr dchildren)
;; 				      t
;; 				      (append (formula-args arg) nargs)
;; 				      (append (domnode-children child) nchildren)
;; 				      (cons child rchildren)))
;; 		   (t
;; 		    (flatten-and-args-aux (cdr args)
;; 				      (cdr dchildren)
;; 				      changed
;; 				      (cons arg nargs)
;; 				      (cons child nchildren)
;; 				      rchildren)))))))
  














;; (defun faa-insert-child (child children)
;;   (cond ((endp children)
;; 	 (list child))
;; 	((> (formula-value (domnode-form (car children)))
;; 	    (formula-value (domnode-form child)))
;; 	 (cons (car children) (faa-insert-child child (cdr children))))
;; 	(t 
;; 	 (cons child (cdr children)))))




;; (defun flatten-and-args (tree form args)
;;   (let* ((changed t)
;; 	 (children (domnode-children tree)))
;;     (loop while changed
;; 	  do (multiple-value-bind
;; 		 (nargs nchildren rchildren nchanged)
;; 		 (flatten-and-args-aux args children nil nil nil nil)
;; 	       (setf args nargs)
;; 	       (setf children nchildren)
;; 	       (setf changed nchanged)
;; 	       (dolist (rc rchildren)
;; 		 (format t "rc: ~A~%" rc)
;; 		 (setf (domnode-children rc) nil)
;; 		 (let* ((rf (domnode-form rc))
;; 			(fparents (remove form (formula-slot2 rf)))
;; 			(cparent (nca (mapcar #'formula-slot1 fparents))))
;; 		   (format t "parents: ~A~%" (formula-slot2 rf))
;; 		   (format t "fparents: ~A~%" fparents)
;; 		   (format t "cparent: ~A~%" cparent)
;; 		   (setf (formula-slot2 rf) fparents)    
;; 		   (setf (domnode-parent rc) cparent)
;; 		   (when cparent
;; 		     (setf (domnode-children cparent)
;; 			   (faa-insert-child rc (domnode-children cparent)))))))
;; 	  finally (progn
;; 		    (dolist (nc children)
;; 		      (setf (domnode-parent nc) tree))
;; 		    (setf (domnode-children tree)
;; 			  children)
;; 		    (setf (domnode-form tree)
;; 			  (sb-and-form args))))))
	

;; (defun dom-flatten (tree)
;;   (let ((form (domnode-form tree))
;; 	(children (domnode-children tree)))
;;     (format t "form parents: ~A~%" (formula-slot2 form))
;;     (dolist (child children) (dom-flatten child))
;;     (let ((args (mapcar (lambda (x) 
;; 			  (cond ((vec-p x)
;; 				 (let* ((n (vec-num-bits x))
;; 					(vec (new-vec n)))
;; 				   (dotimes (i n (make-unique-vec vec))
;; 				     (vec-set-bit vec i
;; 						  (domnode-form (formula-slot1 (vec-get-bit x i)))))))
;; 				((formula-p x)
;; 				 (domnode-form (formula-slot1 x)))
;; 				(t x)))
;; 			(formula-args form))))
;;       (case (formula-fn form)
;; 	(var form)
;; 	(and (flatten-and-args tree form args))
;; 	(<-> (setf (domnode-form tree) (equiv-form args)))
;; 	(not (setf (domnode-form tree) (sb-not-form (car args))))
;; 	(bit (setf (domnode-form tree) (make-unique-formula :fn 'bit :args args)))
;; 	(=   (setf (domnode-form tree) (equals-form args)))
;; 	(if  (setf (domnode-form tree) (if-form args)))
;; 	(get (setf (domnode-form tree) (make-unique-formula :fn 'get :args args)))
;; 	(set (setf (domnode-form tree) (apply   #'set-form args)))
;; 	(otherwise (break (format nil "~&dom-flatten: unknown function ~A.~%" (formula-fn form))))))
;;     (setf (formula-slot1 (domnode-form tree)) tree)
;;     (setf (formula-slot2 (domnode-form tree)) (formula-slot2 form))
;;     tree))
	
;; builds the dominator tree for form, and flattens out and forms that are dominated by their parents.  
;; returns the new tree with the new form in its domnode-form slot.
(defun build-dom-tree (form)
  (compute-form-parents form)
  (let ((heap (create-heap (lambda (x y) (< (formula-value x) (formula-value y))))))
    (heap-insert heap form)
    (loop until (= (heap-count heap) 0)
	  do (let ((form (heap-remove heap)))
	       (build-dom-node form)
	       (dolist (arg (formula-args form))
		 (heap-add-arg heap arg)))))
  (let ((tree (formula-slot1 form)))
;;    (clear-both-slots form)
    (setf (formula-slot2 form) 'foo)
    (clear-slot2 form)
    tree))


;; (defun dom-flatten-aux (tree)
;;   (dolist (child (domnode-children tree)) (dom-flatten-aux child))
;;   (let* ((form (domnode-form tree))
;; 	 (args (mapcar (lambda (x) 
;; 			  (cond ((vec-p x)
;; 				 (let* ((n (vec-num-bits x))
;; 					(vec (new-vec n)))
;; 				   (dotimes (i n (make-unique-vec vec))
;; 				     (vec-set-bit vec i
;; 						  (formula-slot2 (vec-get-bit x i))))))
;; 				((formula-p x)
;; 				 (formula-slot2 x))
;; 				(t x)))
;; 			(formula-args form))))
;;     (setf (formula-slot2 form)
;; 	  (case (formula-fn form)
;; 	    (var form)
;; 	    (and
;; 	     ;; mark all the nodes immediately dominated by the current node.
;; 	     (dolist (child (domnode-children tree))
;; 	       (setf (formula-slot1 (domnode-form child)) t))
;; 	     ;; flattened all the marked args.
;; 	     (let ((ans (sb-and-form (dom-flatten-and-args (formula-args form)
;; 						       :condition #'formula-slot1))))
;; 	       ;; unmark all the immediately dominated nodes
;; 	       (dolist (child (domnode-children tree))
;; 		 (setf (formula-slot1 (domnode-form child)) nil))
;; 	       ans))
;; 	    (<-> (equiv-form args))
;; 	    (not (sb-not-form (car args)))
;; 	    (bit (make-unique-formula :fn 'bit :args args))
;; 	    (=   (equals-form args))
;; 	    (if  (if-form args))
;; 	    (get (make-unique-formula :fn 'get :args args))
;; 	    (set (apply   #'set-form args))
;; 	    (otherwise
;; 	     (break (format nil "~&dom-flatten-aux: unknown function ~A.~%" (formula-fn form))))))))

;; (defun dom-flatten (tree)
;;   (let ((ans (dom-flatten-aux tree)))
;;     (clear-slot2 (domnode-form tree))
;;     ans))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; (defvar *dom-flatten-visited* nil)

;; (defun dom-flatten-and-args (tree args nargs)
;;   (cond ((endp args)
;; 	 nargs)
;; 	((and (eq (formula-fn (car args)) 'and)
;; 	      (eq (domnode-parent (formula-slot1 (car args)))
;; 		  tree))
;; 	 (setf (formula-slot1 (car args))
;; 	       nil)
;; 	 (setf (formula-slot2 (car args)) *one*)
;; 	 (dom-flatten-and-args tree
;; 			       (cdr args)
;; 			       (dom-flatten-and-args tree
;; 						     (formula-args (car args))
;; 						     nargs)))
;; 	(t
;; 	 (dom-flatten-and-args tree
;; 			       (cdr args)
;; 			       (cons (car args) nargs)))))

;; (defun get-computed-ans (fv)
;;   (cond ((vec-p fv)
;; 	 (let* ((n (vec-num-bits fv))
;; 		(vec (new-vec n)))
;; 	   (dotimes (i n (make-unique-vec vec))
;; 	     (vec-set-bit vec i (get-computed-ans (vec-get-bit fv i))))))
;; 	((formula-p fv)
;; 	 (the formula (formula-slot2 fv)))
;; 	(t fv)))

;; (defun dom-flatten-form (form)
;;   (if (formula-slot2 form)
;;       (formula-slot2 form)
;;     (setf (formula-slot2 form)
;; 	  (case (formula-fn form)
;; 	    (var form)
;; 	    (const form)
;; 	    (otherwise
;; 	     (let ((args (mapcar #'get-computed-ans (formula-args form))))
;; 	       (case (formula-fn form)
;; 		 (and (sb-and-form (dom-flatten-and-args (formula-slot1 form) args nil)))
;; 		 (<-> (equiv-form args))
;; 		 (not (sb-not-form (first args)))
;; 		 (= (equals-form args))
;; 		 (if (if-form args))
;; 		 (bit (apply #'get-bit args))
;; 		 (get (apply #'get-form args))
;; 		 (set (apply #'set-form args))
;; 		 (mv (mv-form (formula-type form) args)))))))))

;; (defun dom-flatten-node (node)
;;   (let ((children (domnode-children node)))
;;     (setf *dom-flatten-visited*
;; 	  (cons (domnode-form node)
;; 		*dom-flatten-visited*))
;;     (setf (domnode-children node) nil)
;;     (dolist (child children) (dom-flatten-node child))
;;     (let ((form (dom-flatten-form (domnode-form node))))
;;       (setf *dom-flatten-visited*
;; 	    (cons form *dom-flatten-visited*))
;;       (setf (formula-slot2 form) form)
;;       (cond ((and (not (eq form (domnode-form node)))
;; 		  (formula-slot1 form))
;; ;;	     (format t "here. value: ~A~%" (domnode-value node))
;; 	     (let ((nnode (formula-slot1 form)))
;; ;;	       (format t "node: ~A~%nnode: ~A~%" node nnode)
;; 	       (setf (domnode-parent nnode)
;; 		     (bnca (domnode-parent node) (domnode-parent nnode)))
;; 	       (setf (domnode-height nnode)
;; 		     (1+ (domnode-height (domnode-parent nnode))))))
;; 	    (t
;; ;;	     (format t "there. value: ~A~%" (domnode-value node))
;; 	     (setf (domnode-form node) form)
;; 	     (setf (formula-slot1 form) node)))
;;       form)))

;; (defun refill-dom-children-aux (fv)
;;   (cond ((vec-p fv)
;; 	 (dotimes (i (vec-num-bits fv))
;; 	   (refill-dom-children-aux (vec-get-bit fv i))))
;; 	((formula-p fv)
;; 	 (unless (formula-slot2 fv)
;; 	   (setf (formula-slot2 fv) t)
;; 	   (let* ((node (formula-slot1 fv))
;; 		  (parent (domnode-parent node)))
;; 	     (if parent
;; 		 (setf (domnode-children parent)
;; 		       (cons node (domnode-children parent)))
;; 	       (break))
;; 	     (dolist (arg (formula-args fv)) (refill-dom-children-aux arg))
;; 	     (setf (domnode-children node) (sort-domnodes (domnode-children node)))))))
;;   nil)
      
;; (defun refill-dom-children (form)
;;   (refill-dom-children-aux form)
;;   (clear-slot2 form)
;;   nil)

;; (defun restrict-fhash-to-forms-aux (fv)
;;   (cond ((vec-p fv)
;; 	 (setf (gethash (vec-key fv) *fhash*)
;; 	       fv)
;; 	 (dotimes (i (vec-num-bits fv))
;; 	   (restrict-fhash-to-forms-aux (vec-get-bit fv i))))
;; 	((formula-p fv)
;; 	 (unless (formula-slot1 fv)
;; 	   (setf (formula-slot1 fv) t)
;; 	   (setf (gethash (form-key (formula-fn fv)
;; 				    (formula-type fv)
;; 				    (formula-args fv))
;; 			  *fhash*)
;; 		 fv)
;; 	   (dolist (arg (formula-args fv)) (restrict-fhash-to-forms-aux arg)))))
;;   nil)

;; (defun restrict-fhash-to-forms (form)
;;   (clrhash *fhash*)
;;   (restrict-fhash-to-forms-aux form)
;;   (clear-slot1 form)
;;   nil)

;; (defun dom-flatten (tree)
;;   (setf *dom-flatten-visited* nil)
;;   (let ((form (dom-flatten-node tree)))
;;     (dolist (f *dom-flatten-visited*)
;;       (setf (formula-slot1 f) nil)
;;       (setf (formula-slot2 f) nil))
;;     (setf *dom-flatten-visited* nil)
;; ;;    (restrict-fhash-to-forms form)
;;     (let ((ntree (build-dom-tree form)))
;;       (clear-slot1 form)
;;       ntree)))

;; (defun build-flattened-dom-tree (form)
;;   (dom-flatten (build-dom-tree form)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; (defun build-flattened-dom-tree (form)
;;   (build-dom-tree (dom-flatten (build-dom-tree form))))

(defun ap-form-< (form1 form2)
  (or (< (formula-depth form1) (formula-depth form2))
      (and (not (> (formula-depth form1) (formula-depth form2)))
	   (> (formula-value form1) (formula-value form2)))))
  
(defun ap-set-form-value (form nform)
  (let ((s2 (formula-slot2 form)))
    (setf (formula-slot2 form)
	  (cons (if (or (endp s2)
			(ap-form-< nform (first s2)))
		    nform
		  (first s2))
		s2))))

(declaim (ftype (function ((cons formula (cons formula null))) null)
		ap-set-form-to-true-iff))
(defun ap-set-form-to-true-iff (args)
  (let* ((arg1 (first args))
	 (arg2 (second args)))
    (if (ap-form-< arg1 arg2)
	(ap-set-form-value arg2 arg1)
      (ap-set-form-value arg1 arg2)))
  nil)

(declaim (ftype (function (formula) null) ap-set-form-to-true))
(defun ap-set-form-to-true (form)
  (ap-set-form-value form *one*)
  (ap-set-form-value (not-form form) *zero*)
  (case (formula-fn form)
;;     (not (let ((arg (first (formula-args form))))
;; 	   (when (eq (formula-fn arg) '<->)
;; 	     (let ((args (formula-args arg)))
;; 	       (ap-set-form-to-true-iff (list (first args)
;; 					      (not-form (second args))))))))
    (and (mapcar #'ap-set-form-to-true (formula-args form))))
;;     (<-> (ap-set-form-to-true-iff (formula-args form))))
  nil)

(declaim (ftype (function ((cons formula (cons formula null))) null)
		ap-pop-form-value-iff))
(defun ap-pop-form-value-iff (args)
  (let* ((arg1 (first args))
	 (arg2 (second args)))
    (if (ap-form-< arg1 arg2)
	(setf (formula-slot2 arg2)
	      (rest (formula-slot2 arg2)))
      (setf (formula-slot2 arg1)
	    (rest (formula-slot2 arg1)))))
  nil)

(declaim (ftype (function (formula) null) ap-pop-form-value))
(defun ap-pop-form-value (form)
  (setf (formula-slot2 form) (rest (formula-slot2 form)))
  (let ((nform (not-form form)))
    (setf (formula-slot2 nform) (rest (formula-slot2 nform))))
  (case (formula-fn form)
;;     (not (let ((arg (first (formula-args form))))
;; 	   (when (eq (formula-fn arg) '<->)
;; 	     (let ((args (formula-args arg)))
;; 	       (ap-pop-form-value-iff (list (first args)
;; 					    (not-form (second args))))))))
    (and (mapcar #'ap-pop-form-value (formula-args form))))
;;    (<-> (ap-pop-form-value-iff (formula-args form))))
  nil)

;; (defun ap-flatten-and-args-aux (args fargs)
;;   (cond ((endp args) fargs)
;; 	((eq (formula-fn (car args)) 'and)
;; 	 (ap-flatten-and-args-aux (cdr args)
;; 				  (ap-flatten-and-args-aux (formula-args (car args))
;; 							   (cons (car args) fargs))))
;; 	(t (ap-flatten-and-args-aux (cdr args) (cons (car args) fargs)))))

;; (defun ap-flatten-and-args (args)
;;   (sort (ap-flatten-and-args-aux args nil) #'> :key #'formula-value))

;; (defun flatten-args-with-new-values (args fargs)
;;   (cond ((endp args) (sort fargs :test '> :key #'formula-value))
;; 	((eq (formula-fn (car args)) 'and)
;; 	 (flatten-args-with-new-values (cdr args)
;; 				       (flatten-args-with-new-values (formula-args (car args))
;; 								     fargs)))
;; 	(t
;; 	 (let ((nfargs (cons (car args) fargs)))
;; 	   (flatten-args-with-new-values (cdr args)
;; 					 (if (or (endp (formula-slot2 (car args)))
;; 						 (eq (first (formula-slot2 (car args)))
;; 						     (car args))
;; 					     nfargs
;; 					   (cons (first (formula-slot2 (car args)))
;; 						 nfargs)))))))

(defun ap-and (children args sargs)
  (cond ((endp children) (mapcar #'ap-pop-form-value sargs))
	((or (endp args)
	     (<= (formula-value (car args))
		 (formula-value (domnode-form (car children)))))
	 (and-propagation-aux (car children))
	 (ap-and (cdr children) args sargs))
	(t
	 (ap-set-form-to-true (car args))
	 (ap-and children (cdr args) (cons (car args) sargs))))
    nil)

(defun ap-top-value (fv)
  (cond ((vec-p fv)
	 (let* ((n (vec-num-bits fv))
		(vec (new-vec n)))
	   (dotimes (i n (make-unique-vec vec))
	     (vec-set-bit vec i (ap-top-value (vec-get-bit fv i))))))
	((formula-p fv)
	 (unless (formula-slot2 fv) (break))
	 (first (formula-slot2 fv)))
	(t fv)))

(defun get-all-and-args-aux (args nargs condition)
  (cond ((endp args)
	 nargs)
	((and (eq (formula-fn (car args)) 'and)
	      (funcall condition (car args)))
	 (get-all-and-args-aux (cdr args)
			       (cons (car args)
				     (get-all-and-args-aux (formula-args (car args))
							   nargs
							   condition))
			       condition))
	(t
	 (get-all-and-args-aux (cdr args)
			       (cons (car args) nargs)
			       condition))))

(defun get-all-and-args (args &key (condition (lambda (x) (declare (ignore x)) t)))
  (and-args (get-all-and-args-aux args nil condition)))

(defun and-propagation-aux (tree)
  (let* ((form (domnode-form tree))
	 (val (case (formula-fn form)
		(var form)
		(const form)
		(if (let* ((args (formula-args form))
			   (test (first args))
			   (ntest (sb-not-form test))
			   (then (second args))
			   (else (third args)))
		      (dolist (child (domnode-children tree))
			(cond ((eq (domnode-form child) then)
			       (ap-set-form-to-true test)
			       (and-propagation-aux child)
			       (ap-pop-form-value test))
			      ((eq (domnode-form child) else)
			       (ap-set-form-to-true ntest)
			       (and-propagation-aux child)
			       (ap-pop-form-value ntest))
			      (t
			       (and-propagation-aux child))))
		      (if-form (list (ap-top-value test)
				     (ap-top-value then)
				     (ap-top-value else)))))
		(and (let ((args (get-all-and-args (formula-args form)
						   :condition
						   (lambda (x) (not (eq (domnode-parent (formula-slot1 x))
									tree))))));;(formula-args form)));(flatten-and-args (formula-args form))));;))
		       (if (atom args)
			   args
			 (progn
			   (ap-and (domnode-children tree) args nil)
			   (sb-and-form (mapcar #'ap-top-value (formula-args form)))))))
		(otherwise (mapcar #'and-propagation-aux (domnode-children tree))
			   (let ((args (mapcar #'ap-top-value (formula-args form))))
			     (case (formula-fn form)
			       (<-> (equiv-form args))
			       (not (sb-not-form (car args)))
			       (bit (apply #'get-bit args))
			       (=   (equals-form args))
			       (get (apply #'get-form args))
			       (set (apply #'set-form args))
			       (otherwise
				(break (format nil
					       "and-propagation-aux: unknown function: ~A."
					       (formula-fn form))))))))))
    (setf (formula-slot2 form)
	  (cons val (formula-slot2 form)))
    val))
	 
(defun and-propagation-iteration (tree)
  (let ((ans (and-propagation-aux tree)))
    (clear-both-slots (domnode-form tree))
    ans))
	      	
(defun and-propagation (form)
  (let ((changed t)
	(form (flatten form)))
    (setf *domnode-count* -1)
    (loop for i from 1 to 10
	  while (and changed (not (eq (formula-fn form) 'const)))
	  do (format t "iteration: ~A~%" i)
	  do (setf changed nil)
	  do (let* ((tree (build-dom-tree form))
		    (nform (and-propagation-iteration tree)))
	       ;;(clear-slot2 form)
	       (unless (eq form nform) (setf changed t))
	       (setf form (flatten nform)))
	  finally (progn (format t "~&propagation iterations: ~A~%" (1- i))
			 (return form)))))

	     
		   
